
// See http://entropymine.com/imageworsener/bicubic/
float Cubic(float x, float b, float c)
{
    x = abs(x);
    float x2 = x * x;
    float x3 = x2 * x;
    if (x < 1.0)
    {
        return
            (2.0 - 1.5 * b - c) * x3 +
            (-3.0 + 2.0 * b + c) * x2 +
            (1.0 - (1.0 / 3.0) * b);
    }
    else if (x < 2.0)
    {
        return (1.0 / 6.0) * (
            (-b - 6.0 * c) * x3 +
            (6.0 * b + 30.0 * c) * x2 +
            (-12.0 * b - 48.0 * c) * x +
            (8.0 * b + 24.0 * c));
    }
    else
    {
        return 0.0;
    }
}

float DownscaleWeight(float x)
{
    return Cubic(x, 0.0, 0.5);
}

// Return a weighted sample of the source texture. Also return the weight used.
vec4 DownscaleSample(vec2 dest, vec2 center, float offsetX, float offsetY)
{
    const vec2 srcSize = vec2(1297.0, 737.0);
    const vec2 srcTexel = 1.0 / srcSize;
    const vec2 destSize = vec2(758.0, 431.0);

    vec2 src = center + srcTexel * vec2(offsetX, offsetY);
    // NOTE: Weight must be scaled to match the destination texel size.
    float wx = DownscaleWeight((src.x - dest.x) * destSize.x);
    float wy = DownscaleWeight((src.y - dest.y) * destSize.y);
    float w = wx * wy;
    vec3 rgb = texture(Texture0, src).rgb;
    return vec4(rgb * w, w);
}

// See http://entropymine.com/imageworsener/resample/
void main()
{
    const vec2 srcSize = vec2(1297.0, 737.0);
    const vec2 srcTexel = 1.0 / srcSize;

    vec2 dest = fragTexCoord0;
    vec2 center = (round(fragTexCoord0 * srcSize - vec2(0.5, 0.5)) + vec2(0.5, 0.5)) * srcTexel;
    vec4 sum = vec4(0.0, 0.0, 0.0, 0.0);
    // A radius of 3 samples all pixels covered by the cubic kernel. (verified empirically)
    for (float dy = -3.0; dy <= 3.0; dy += 1.0)
    {
        for (float dx = -3.0; dx <= 3.0; dx += 1.0)
        {
            sum += DownscaleSample(dest, center, dx, dy);
        }
    }
    sum.rgb /= sum.a;
    Output = vec4(sum.rgb, 1.0);
}
