
void main()
{
    const vec2 dx = vec2(1.0 / 512.0, 0.0);
    const vec2 dy = vec2(0.0, 1.0 / 512.0);
    const vec4 OUTLINE_COLOR = vec4(0.725, 0.667, 0.541, 1.0);

    float glyphY = fragTexCoord1.x;
    float enableOutline = fragTexCoord1.y;

    // Sample nearby texels as a simple kind of edge detection:
    float mask = texture(Texture0, fragTexCoord0).r;
    float g0 = texture(Texture0, fragTexCoord0 - dx).r;
    float g1 = texture(Texture0, fragTexCoord0 + dx).r;
    float g2 = texture(Texture0, fragTexCoord0 - dy).r;
    float g3 = texture(Texture0, fragTexCoord0 + dy).r;
    float g4 = texture(Texture0, fragTexCoord0 + 2.0 * dy).r;
    float g = max(max(max(max(g0, g1), g2), g3), g4);
    float edge = saturate(g - mask);
    
    // Interior downward shadow:
    float shadow = 1.0 - 0.4 * saturate(-3.0 + 4.0 * glyphY);
    vec4 shadowMask = vec4(shadow, shadow, shadow, 1.0);

    // Outline (more opaque at the bottom):
    float outline = (enableOutline > 0.0) ? (1.0 - glyphY) : 0.0;

    Output = (shadowMask * fragColor * mask) + (edge * outline * OUTLINE_COLOR);
}
