
void main()
{
    const float midpoint = 0.25;
    float contrast = fragTexCoord1.x;
    float invert = fragTexCoord1.y;

    vec3 rgb = texture(Texture0, fragTexCoord0).rgb;
    if (invert != 0.0) rgb = 1.0 - rgb;
    vec3 gray = vec3(ToGrayscale(rgb));
    rgb = lerp(gray, rgb, saturate(-1.0 + 2.0 * contrast));
    const vec3 mid3 = vec3(midpoint);
    rgb = saturate(((rgb - mid3) * contrast) + mid3);
    Output = vec4(fragColor.rgb * rgb, 1.0);
}
