
void main()
{
    bool singleChannel = fragTexCoord1.x > 0.0;
    bool solid = fragTexCoord1.x < 0.0;
    float colorOverlay = fragTexCoord1.y;

    vec4 tex = texture(Texture0, fragTexCoord0);
    if (singleChannel) tex.rgba = tex.rrrr;
    if (solid) tex.rgba = vec4(1.0, 1.0, 1.0, 1.0);
    
    // HACK: Don't apply the color overlay to the drop shadows that are baked into EXAs.
    if (tex.a < 0.5) colorOverlay = 0.0;

    if (colorOverlay > 0.0)
    {
        tex.rgb = mix(tex.rgb, fragColor.rgb * tex.a, colorOverlay);
        Output = tex;
    }
    else
    {
        Output = fragColor * tex;
    }
}
